#pragma once

#define SIMPLE_OPENGL_CLASS_NAME "simple_openGL_class_name"

class COpenGLControl
{
private:
	HDC hDC;
	HWND* hWnd;
	HGLRC hRC;
	static bool bClassRegistered;
	static bool bGlewInitialized;
	int iMajorVersion, iMinorVersion;
	int iFPSCount, iCurrentFPS;
	clock_t tLastSecond;
	mat4 mProjection;
	mat4 mOrtho;
	int iViewportWidth, iViewportHeight;

private:
	void (*initScene)(LPVOID lpParam);
	void (*renderScene)(LPVOID lpParam);
	void (*releaseScene)(LPVOID lpParam);

public:
	COpenGLControl();

	bool initOpenGL(HINSTANCE hInstance, HWND* a_hWnd, int iMajorVersion, int iMinorVersion, void (*a_initScene)(LPVOID), void (*a_renderScene)(LPVOID), void(*a_releaseScene)(LPVOID), LPVOID lpParam);
	void resizeOpenGLViewportFull();
	void setProjection3D(float fFOV, float fAspectRatio, float fNear, float fFar);
	void setOrtho2D(int width, int height);
	mat4* getProjectionMatrix();
	mat4* getOrthoMatrix();
	void render(LPVOID lpParam);
	void releaseOpenGLControl(LPVOID lpParam);
	static void registerSimpleOpenGLClass(HINSTANCE hInstance);
	static void unregisterSimpleOpenGLClass(HINSTANCE hInstance);
	void makeCurrent();
	void swapBuffers();
	bool setVerticalSynchronization(bool bEnabled);
	int getFPS();
	int getViewportWidth();
	int getViewportHeight();

private:
	bool initGLEW(HINSTANCE hInstance);
};

LRESULT CALLBACK msgHandlerSimpleOpenGLClass(HWND, UINT, WPARAM, LPARAM);
